"use client";

import { Column } from "./Column";
import { TCard } from "@/lib/types/kanban";

interface IBoardProps {
  cards: TCard[];
  insertCard: (card: TCard) => void;
  updateCard: (card: TCard) => void;
  deleteCard: (card: TCard) => void;
}

export const Board = ({
  cards,
  insertCard,
  updateCard,
  deleteCard,
}: IBoardProps) => {
  return (
    <div className="flex flex-col h-full w-full p-4 lg:flex-row lg:gap-3 lg:overflow-auto lg:p-12">
      <Column
        className="flex-1"
        title="Pending"
        column="pending"
        cards={cards}
        insertCard={insertCard}
        updateCard={updateCard}
        deleteCard={deleteCard}
      />
      <Column
        className="flex-1"
        title="In Progress"
        column="inprogress"
        cards={cards}
        insertCard={insertCard}
        updateCard={updateCard}
        deleteCard={deleteCard}
      />
      <Column
        className="flex-1"
        title="Completed"
        column="completed"
        cards={cards}
        insertCard={insertCard}
        updateCard={updateCard}
        deleteCard={deleteCard}
      />
    </div>
  );
};
