import {
  Sidebar,
  SidebarContent,
  SidebarGroup,
  SidebarGroupLabel,
  SidebarMenu,
  SidebarMenuButton,
  SidebarMenuItem,
} from "@/components/ui/sidebar";

export function OwnerSidebar() {
  return (
    <Sidebar>
      <SidebarContent>
        <SidebarGroup>
          <SidebarGroupLabel>Task</SidebarGroupLabel>
          <SidebarMenu>
            <SidebarMenuItem key={"owner"}>
              <SidebarMenuButton asChild>
                <a href={"/app/owner"}>
                  <span>{"Member Tasks"}</span>
                </a>
              </SidebarMenuButton>
            </SidebarMenuItem>
          </SidebarMenu>
        </SidebarGroup>
        <SidebarGroup>
          <SidebarGroupLabel>Member</SidebarGroupLabel>
          <SidebarMenu>
            <SidebarMenuItem key={"member"}>
              <SidebarMenuButton asChild>
                <a href={"/app/owner/member"}>
                  <span>{"Member List"}</span>
                </a>
              </SidebarMenuButton>
            </SidebarMenuItem>
          </SidebarMenu>
        </SidebarGroup>
      </SidebarContent>
    </Sidebar>
  );
}
