import { QueryConfig } from "@/lib/react-query";
import { User } from "@/lib/types/user";
import { createClient } from "@/utils/supabase/client";
import { queryOptions, useQuery } from "@tanstack/react-query";

export const getMembers = async (): Promise<User[]> => {
  const supabase = createClient();
  const { data, error } = await supabase
    .from("user")
    .select("*")
    .eq("role", "MEMBER")
    .order("position", { ascending: true });

  if (error) {
    throw new Error(error.message);
  }
  return data as User[];
};

export const getMembersQueryOptions = () => {
  return queryOptions({
    queryKey: ["members"],
    queryFn: () => getMembers(),
  });
};

export const useMembers = () => {
  return useQuery({
    ...getMembersQueryOptions(),
  });
};
