import { z } from "zod";
import { UserRoleEnum } from "../enums/role";

export const updateUserSchema = z.object({
  id: z.string().nullable(),
  email: z.string().email("Please enter a valid email address"),
  name: z.string().min(3, "Name must be at least 3 characters").nullable(),
  role: z.enum(Object.values(UserRoleEnum) as [string, ...string[]]).optional(),
  position: z.number().default(0).nullable(),
});

export type UpdateUserInput = z.infer<typeof updateUserSchema>;
