import { TOwnerColumnProps } from "@/lib/types/owner-kanban";
import OwnerBoardCard from "./owner-board-card";

export default function OwnerBoardColumn({
  user,
  cards,
  className,
}: TOwnerColumnProps) {
  return (
    <div className={`flex-1 mb-2.5 lg:mb-0 ${className}`}>
      <div className="mb-3 flex items-center justify-between">
        <h3 className={`font-medium`}>{user.name}</h3>
        <span className="text-sm text-neutral-400">{cards?.length}</span>
      </div>
      <div
        className={`h-full w-full transition-colors bg-neutral-800/0`}
      >
        {cards?.map((card) => (
          <OwnerBoardCard
            key={card?.id}
            card={card}
          />
        ))}
      </div>
    </div>
  );
}
