"use client";

import { useUser } from "@/lib/auth";
import { UserRoleEnum } from "@/lib/enums/role";
import { useRouter } from "next/navigation";
import { useEffect } from "react";

export default function Home() {
  const router = useRouter();
  const user = useUser();

  useEffect(() => {
    if (user.data?.role == UserRoleEnum.OWNER) {
      router.replace("/app/owner");
    } else if (user.data?.role == UserRoleEnum.MEMBER) {
      router.replace("/app/member");
    } else {
      if (user.data && user.data.role == null) {
        router.replace("/auth/role");
      } else {
        router.replace("/auth/login");
      }
    }
  }, [user]);

  return <div></div>;
}
