export enum UserRoleEnum {
  OWNER = "OWNER",
  MEMBER = "MEMBER",
}

export function toRoleEnum(role: string | null): UserRoleEnum | null {
  switch (role) {
    case "OWNER":
      return UserRoleEnum.OWNER;
    case "MEMBER":
      return UserRoleEnum.MEMBER;
    default:
      return null;
  }
}

export function getRoleName(role: UserRoleEnum) {
  switch (role) {
    case UserRoleEnum.OWNER:
      return "Owner";
    case UserRoleEnum.MEMBER:
      return "Member";
    default:
      return "Unknown";
  }
}

export function getRoleFromId(id: number | null): UserRoleEnum | null {
  switch (id) {
    case 1:
      return UserRoleEnum.OWNER;
    case 2:
      return UserRoleEnum.MEMBER;
    default:
      return null;
  }
}
